/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Floating Anim
**
** DESCRIPTION:	Manages floating anims
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/
#ifndef FLOATING_ANIM_H
#define FLOATING_ANIM_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "../Utils/SceneManager.h"
#include "../Utils/theGraphicsManager.h"
#include "../Villagers/VillagerAttachmentInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int FloatingAnim_c_iMaxFloatingAnims = 512;
const int FloatingAnim_c_iNumFramesBetweenUpdates = 6;

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum EFloatingAnim
{
	eFloatingAnim_None = -1,

	eFloatingAnim_Waves1 = 0,
	eFloatingAnim_SparkleYellow,
	eFloatingAnim_WhiteSparkle,
	eFloatingAnim_WhiteSparkleBig,
	eFloatingAnim_Dust,
	eFloatingAnim_Algae,
	eFloatingAnim_Rainbow,
	eFloatingAnim_Bubble,
	eFloatingAnim_Candle,
	eFloatingAnim_Fire,
	eFloatingAnim_Petal,
	eFloatingAnim_Waterfall1,
	eFloatingAnim_Waterfall2,
	eFloatingAnim_WaterfallFoam,
	eFloatingAnim_ItemDrop,
	eFloatingAnim_Spray,
	eFloatingAnim_SharpSparkle,
	eFloatingAnim_BlurrySparkle,
	eFloatingAnim_CollectableDrop,
	eFloatingAnim_Footprint,
	eFloatingAnim_RainDrop,
	eFloatingAnim_Smoke,
	eFloatingAnim_ReefFish1,
	eFloatingAnim_ReefFish2,
	eFloatingAnim_ReefFish3,
	eFloatingAnim_SwarmOfBees,
	eFloatingAnim_TinyBubble,

	eFloatingAnim_NumberOf
};	

enum EFloatingAnimEffect
{
	eFloatingAnimEffect_None = -1,

	eFloatingAnimEffect_Rising = 0,
	eFloatingAnimEffect_Falling,
	eFloatingAnimEffect_Launching,
	eFloatingAnimEffect_Vibrating,
	eFloatingAnimEffect_RisingFast,

	eFloatingAnimEffect_NumberOf
};	

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CFloatingAnim : public IVillagerAttachment
{
private:

	struct SAnim
	{
		union UImage
		{
			EImage				m_eImage;
			ldwImageGrid *		m_pImage;
		};

		UImage					m_uImage;
		int						m_iNumFrames;
		bool					m_bStartOnRandomFrame;
		int						m_iSortOffset;
	};

	struct SInst
	{
		friend class CFloatingAnim;

	private:

		//structure data
		EFloatingAnim			m_eType;
		EFloatingAnimEffect		m_eEffect;
		ldwPoint				m_sPos;
		bool					m_bIsCentered;
		int						m_iCurrentFrame;
		int						m_iNumFrames;
		int						m_iAnimSpeed;
		int						m_iAnimIdx;
		ldwPoint				m_sOffset;
		ldwPoint				m_sVel;
		int						m_iWhichItem;
		bool					m_bIsLooping;
		EScenePriority			m_eScenePriority;
		ldwImageGrid *			m_pAnim;

		//structure methods
		public:		void UpdateOffset();
	};

	//class data
	static SAnim				m_sAnim[eFloatingAnim_NumberOf];
	SInst						m_InstArray[FloatingAnim_c_iMaxFloatingAnims];

	int							m_iFrameCounter;

	//class methods
	//setup
	public:		CFloatingAnim();
	public:		~CFloatingAnim();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		void Reset();
	
	//process
	public:		const int AddAnim(const EFloatingAnim eFloatingAnim, const ldwPoint sPos);
	public:		const int AddAnim(const EFloatingAnim eFloatingAnim, const ldwPoint sPos, const bool bIsCentered);
	public:		const int AddAnim(const EFloatingAnim eFloatingAnim, const ldwPoint sPos, int iAnimSpeed, const bool bIsLooping, const EFloatingAnimEffect eFloatingAnimEffect, const EScenePriority eScenePriority, const bool bIsCentered = false);
	public:		void RemoveType(const EFloatingAnim eFloatingAnim);
	public:		void Remove(const int iAnim);

	public:     void ScareFish(ldwPoint scarePoint);

	public:		void Draw() const;
	public:		void DrawOverlays() const;
	public:		void Draw(const int iFloatingAnim) const;
	public:		void Update();
	
	//access
	public:		const int GetNumberOfType(const EFloatingAnim eType) const;
	public:		void SetPos(const int iAnim, const ldwPoint sPos);
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CFloatingAnim		FloatingAnim;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/
